#ifndef F_CPU
#define F_CPU 12288000UL
#endif

#include <avr/io.h>
#include <avr/interrupt.h>		// Definition von Interrupts
#include <util/delay.h>

void SPIsoft_Init();

int main()
{
	DDRB = (1<<DDB4);

	DDRD = 0xFF;
	SPCR = (1<<SPE)|(1<<SPIE);						
	
	SPIsoft_Init();							// fr SPI Bugfix - Init Routine
	
	while(1)
	{
//		SPDR = 0x01;
		while(!(SPSR & (1<<SPIF)));
		_delay_us(10);						// fr SPI Bugfix: 10us sollte reichen, falls die Daten nicht korrekt bertragen werden, dann Wert erhhen
		PORTD = SPDR;
	}
}

void SPIsoft_Init()
{
	PCICR |= 1<<PCIE0;                  // Pin Change Interrupt, auf PortB aktivieren
	PCMSK0|= 1<<PINB5 |				    // Pin Change Interrupt, wenn CLK Pin gendert
			 1<<PINB2;				    // Pin Change Interrupt, wenn SS Pin gendert
	sei();
}

ISR(PCINT0_vect)
{
	if( !(PINB>>PINB5) &    1 ) {return;};                  // Falls nicht steigende Flanke , dann abbrechen
	
	SPDR = ( SPDR << 1 ) + ((PINB>>PINB3)& 1);				// Bit-Wert von PinB3 in SPDR schieben
}
